# 5 Introduction to R and QGIS
# c) Introduction to RStudio


# It is time to execute your first line of code!
# Navigate your cursor somewhere on the line of code you want to execute
# Press ctrl + ENTER
print("Hello, R!")

# Next try it for yourself and print a statement
# ...your code...
print("Today is Thursday")


# You can use R like a calculator!
3 + 3
12 - 9

# Assigning variables in RStudio
my_variable <- 10
my_other_variable <- 11

# Checking the variables
print(my_variable)
# You can also see all of your predefined variables in the Enviroment tab
print(my_other_variable)

# Calculate using variables
my_variable + my_other_variable

# Your own variables and calculations
# ... your code...


# Installing libraries

# Install.packages is only needed when you use a library for the first time
install.packages("ggplot2")

# Loads the installed library
library(ggplot2)


# Dataframes

# Creating the Dataframe
df <- data.frame(
  Name = c("Alice", "Bob", "Charlie"),
  Age = c(25, 30, 35),
  City = c("New York", "London", "Paris")
)

# Checking the dataframe
print(df)

# Your own dataframe
# ... your code...

# Plotting data: Example using my dataframe
# Bar plot
ggplot(df, aes(x = Name, y = Age, fill = City)) + # ggplot needs an argument for the data, the x and the y values
  geom_bar(stat = "identity") +# to make sure that the age is displayed as its actual value
  theme_minimal() # design choice

# Check your current working directory, here any data you create in R is stored
getwd()

# Change your working directory
# Replace the path below with the folder you want to work in
# On Windows, use either double backslashes "\\" or forward slashes "/"
setwd("C:/Users/YourName/Documents/MyProject") # adjust this to a place of your liking!

# Check again to confirm the change
getwd()

